const colors = [["F75A5A","FFA955","FFD63A","6DE1D2"],["FFCD4B","FF7676","FF4B91","0802A3"],["C0E218","F37121","C70039","111D5E"],["FF165D","FF9A00","F6F7D7","3EC1D3"],["FAEF5D","FF004D","7E2553","1D2B53"],["EC53B0","9D44C0","4D2DB7","0E21A0"]]
const palette = Math.floor(Math.random()*colors.length);

window.onbeforeunload = function() {
    return "";
}

const textCollection = document.querySelectorAll("h1, h2, h3, h4, h5, h6, li, p, figcaption, a");

const imgCollection = document.querySelectorAll("img, svg, figure, a, a *");

 const elementCollection = document.querySelectorAll("*");

textCollection.forEach(text =>{

    text.addEventListener("click", ()=> {
        text.textContent = [...text.textContent].map(x => x != ' ' && x != '\n' ? '■' : x).join('');
        const c = colors[palette][Math.floor(Math.random()*4)];
        text.style.color = "#"+c;
    });

});

imgCollection.forEach(img => {
    img.addEventListener("click", () => {
        const div = document.createElement("div");
        const w = img.offsetWidth;
        const h = img.offsetHeight;
        const c = colors[palette][Math.floor(Math.random()*4)];
        div.setAttribute("style", `background-color: #${c}; minWidth: ${w}; minHeight: ${h}px; width: ${w}px; height: ${h}px`);
        img.replaceWith(div);
    })
})

 elementCollection.forEach(element => {
    element.addEventListener("click", () => {
       element.style.border = "1px solid black";
     })
})
